<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BeyondCorp\Resource;

use Google\Service\BeyondCorp\GoogleCloudBeyondcorpSecuritygatewaysV1Application;
use Google\Service\BeyondCorp\GoogleCloudBeyondcorpSecuritygatewaysV1ListApplicationsResponse;
use Google\Service\BeyondCorp\GoogleLongrunningOperation;

/**
 * The "applications" collection of methods.
 * Typical usage is:
 *  <code>
 *   $beyondcorpService = new Google\Service\BeyondCorp(...);
 *   $applications = $beyondcorpService->projects_locations_securityGateways_applications;
 *  </code>
 */
class ProjectsLocationsSecurityGatewaysApplications extends \Google\Service\Resource
{
  /**
   * Deletes a single Application. (applications.delete)
   *
   * @param string $name Required. Name of the resource.
   * @param array $optParams Optional parameters.
   *
   * @opt_param string requestId Optional. An optional request ID to identify
   * requests. Specify a unique request ID so that if you must retry your request,
   * the server will know to ignore the request if it has already been completed.
   * The server will guarantee that for at least 60 minutes after the first
   * request. For example, consider a situation where you make an initial request
   * and the request times out. If you make the request again with the same
   * request ID, the server can check if original operation with the same request
   * ID was received, and if so, will ignore the second request. This prevents
   * clients from accidentally creating duplicate commitments. The request ID must
   * be a valid UUID with the exception that zero UUID is not supported
   * (00000000-0000-0000-0000-000000000000).
   * @opt_param bool validateOnly Optional. If set, validates request by executing
   * a dry-run which would not alter the resource in any way.
   * @return GoogleLongrunningOperation
   * @throws \Google\Service\Exception
   */
  public function delete($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('delete', [$params], GoogleLongrunningOperation::class);
  }
  /**
   * Gets details of a single Application. (applications.get)
   *
   * @param string $name Required. The resource name of the Application using the
   * form: `projects/{project_id}/locations/global/securityGateway/{security_gatew
   * ay_id}/applications/{application_id}`
   * @param array $optParams Optional parameters.
   * @return GoogleCloudBeyondcorpSecuritygatewaysV1Application
   * @throws \Google\Service\Exception
   */
  public function get($name, $optParams = [])
  {
    $params = ['name' => $name];
    $params = array_merge($params, $optParams);
    return $this->call('get', [$params], GoogleCloudBeyondcorpSecuritygatewaysV1Application::class);
  }
  /**
   * Lists Applications in a given project and location.
   * (applications.listProjectsLocationsSecurityGatewaysApplications)
   *
   * @param string $parent Required. The parent location to which the resources
   * belong. `projects/{project_id}/locations/global/securityGateways/{security_ga
   * teway_id}`
   * @param array $optParams Optional parameters.
   *
   * @opt_param string filter Optional. A filter specifying constraints of a list
   * operation. All fields in the Application message are supported. For example,
   * the following query will return the Application with displayName "test-
   * application" For more information, please refer to
   * https://google.aip.dev/160.
   * @opt_param string orderBy Optional. Specifies the ordering of results. See
   * [Sorting
   * order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
   * for more information.
   * @opt_param int pageSize Optional. The maximum number of items to return. If
   * not specified, a default value of 50 will be used by the service. Regardless
   * of the page_size value, the response may include a partial list and a caller
   * should only rely on response's next_page_token to determine if there are more
   * instances left to be queried.
   * @opt_param string pageToken Optional. The next_page_token value returned from
   * a previous ListApplicationsRequest, if any.
   * @return GoogleCloudBeyondcorpSecuritygatewaysV1ListApplicationsResponse
   * @throws \Google\Service\Exception
   */
  public function listProjectsLocationsSecurityGatewaysApplications($parent, $optParams = [])
  {
    $params = ['parent' => $parent];
    $params = array_merge($params, $optParams);
    return $this->call('list', [$params], GoogleCloudBeyondcorpSecuritygatewaysV1ListApplicationsResponse::class);
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ProjectsLocationsSecurityGatewaysApplications::class, 'Google_Service_BeyondCorp_Resource_ProjectsLocationsSecurityGatewaysApplications');
